import { world } from "@minecraft/server";

world.afterEvents.itemUse.subscribe(event => {
    const player = event.source;
    const item = event.itemStack;

    if (item.typeId === "dg:d1") {
        const viewDirection = player.getViewDirection();
        
        const spawnPos = {
            x: player.location.x + (viewDirection.x * 2),
            y: player.location.y,
            z: player.location.z + (viewDirection.z * 2)
        };

        player.runCommand(`summon dg:chunk_loader ${spawnPos.x} ${spawnPos.y} ${spawnPos.z}`);
        player.runCommand(`particle minecraft:totem_particle ${spawnPos.x} ${spawnPos.y} ${spawnPos.z}`);
        player.runCommand(`playsound random.orb @p`);
    }
});